var sohId = window.localStorage.getItem("orgid");

var map;
var controls;
//var tooltip;
var vectorLayer;
var vectorLayerStartEnd;
var vectorLayerPlayBack;
var lineLayer; 
var poiLayer;
var startRefreshTime = 7000;
var refreshTime = 5000;
var refreshTimeDashboard = 7000;
var idleTime = 0;
var idleSts = false;
var timeoutId = 0;


function updateAssetLocation(lat,lon,assettype,direction,re_device_id,speed) {
    
    console.log("u-SERIAL: "+re_device_id);
    console.log("u-LAT: "+lat);
    console.log("u-LON: "+lon);
    console.log("u-ATYPE: "+assettype);
    console.log("u-DIRECTION: "+direction);
    
    var myLatlngf = new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857');
    
    for (var f = 0; f < vectorLayer.features.length; f++) {
        if (vectorLayer.features[f].id == re_device_id) {
            //console.log(data);
            //console.log(Object.keys(data).length);
            //Close any open popup
            if ($.isEmptyObject(map.popups[0])){

            } else {
                controls['selector'].unselectAll();
            }
            var iconFeature = vectorLayer.features[f];

            iconFeature.style.rotation = direction;
            iconFeature.id = re_device_id;
            
            iconFeature.style.label = speed + ' km/h';
        

            iconFeature.move(myLatlngf);
            //map.setCenter(myLatlngf, 18);
            if(vectorLayer.features.length == 1){
                map.setCenter(myLatlngf, map.zoom);
            }

            break;
        }
    }
    
    timeoutId = setTimeout(() => {
        loadAssetUpdate(serial);                        
    }, refreshTime);
}

//
function loadAssetUpdate(serial) {
    //https://telitrail.com/Fleet/appRead?orgid=195
    var userid = window.localStorage.getItem("userid");
    var orgid = window.localStorage.getItem("orgid");
    //?orgId=191&itemCount=0
    //https://telitrail.com/Live/readenginealerts?orgId=191&itemCount=0
    console.log("MY ASSETS SERIAL: "+serial);
    $.ajax({
        type: "POST",
        url: baseurl+'/Live/appGetAssetBySerial',
        data: {
          unitId: serial,
          userid: userid,
          orgId: orgid
        },
        beforeSend: function(){
        },
        success: function(data){
            
            console.log("---------- MY ASSET UPDATE RES ----------");
            if(data != ""){
                
                var alld = JSON.parse(data);
                var co_payload = alld.co_payload;
                console.log(co_payload);
                
                //lblSpeed lblEngine lblTime lblLocation
                var lblSpeed = co_payload.speed + " Km/h";
                
                if(co_payload.engine == "1"){
                    var lblEngine = "On";
                    $("#engine_sts").css({'color' : '#388e3c'});
                } else {
                    var lblEngine = "Off";
                    $("#engine_sts").css({'color' : '#d32f2f'});
                }
                
                var lblTime = co_payload.gpsidletime;
                var lblLocation = co_payload.location;
                
                $("#lblSpeed").text(lblSpeed);
                $("#lblEngine").text(lblEngine);
                $("#lblTime").text(lblTime);
                $("#lblLocation").text(lblLocation);
                
                //[{"id":"18","regno":"KDP 762V","unitid":"868166058125899","devicetype":"","time":"2024-05-22 02:02:35","systime":"2024-05-20 13:08:29","heartbeat":"0","device_status":"1",
                //"gpsvalidtime":"2024-05-20 13:08:27","gpsidletime":"30 seconds","location":"Kikuyu Ondiri Road, Kikuyu, Kiambu, Central Kenya, Kenya","speed":"0","direction":"269","distance":"0",
                //"distancediff":"501","altitude":"","latitude":"-1.249131","longitude":"36.662838","isgeofence":"0","geofenceid":"0","assetholder":"","status":"1","owner":"195","battery":"100",
                //"assettype":"1","engine":"0","door":"0","fuel":"0.00%","geo_id":"0","geo_status":"","route_status":"0","geo_name":"","geo_idletime":"0","event_type":"acc off","event_code":"3",
                //"satelites":"","messageid":"","inputstatus":"","outputstatus":"","analoginput":"","rtctime":"","publish":"1","publish2":"1","remail":"","islocation":"1","isroute":"0","issubscriber":"0","ev":"0","rv":"0","rvs":"0","bv":"0","bvs":"0","iv":"0","ivs":"0","ia":"0","ias":"0","isl":"0","jr":"0","transfer":""}]
                
                updateAssetLocation(co_payload.latitude,co_payload.longitude,co_payload.assettype,co_payload.direction,co_payload.unitid,co_payload.speed); 
                    
                 
            }
            
            
        }
    });
}

function initLive(mid,lat,lon,assettype,direction,device,regno,speed) {
    if(speed === undefined){
        speed = "0";
    }
    
    var ggl = new OpenLayers.Layer.Google('Google Road',{type: google.maps.MapTypeId.ROADMAP, numZoomLevels: 21, MAX_ZOOM_LEVEL: 22 });
    map = new OpenLayers.Map(mid, {
        layers: [ggl],
        center: new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857'),
        zoom: 16
    });
    vectorLayer = new OpenLayers.Layer.Vector("Markers");
    map.addLayer(vectorLayer);
    
    var assett = properIcon(assettype);
    if(assettype == '7') {
	    var hgt = 30;
	    var agl = 0;
	    var spc = 4;
	} else {
	    var hgt = 36;
	    var agl = direction;
	    var spc = 0;
	}
    
    var feature = new OpenLayers.Feature.Vector(
            new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
            {
                description: ''
            },
            {label: speed + ' km/h', labelOutlineColor: '#fff',labelOutlineWidth: 4, labelAlign: 'cm', labelXOffset: 36, labelYOffset: 10,fontSize: "13px", fontWeight: "bold", fontFamily: 'roboto', externalGraphic: assett, graphicHeight: hgt, graphicXOffset: -12, graphicYOffset: -25, rotation: agl, strokeWidth: 4, strokeColor: '#fff' }
    );
    feature.id = device;
    
    vectorLayer.addFeatures(feature);
	vectorLayer.setVisibility(1);
	
	timeoutId = setTimeout(() => {
        loadAssetUpdate(device);                        
    }, startRefreshTime);
}

/////////////////////////////////// DASHBOARD MAP ///////////////////////////////////
/*
*Dashboard Load All Fleet & Auto Update Location Changes 
*/

//Update Markers Alreadyb Loaded on Map
function dashboardUpdateAsset(lat,lon,assettype,direction,re_device_id,speed,regno) {
    
    var myLatlngf = new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857');
    
    for (var f = 0; f < vectorLayer.features.length; f++) {
        if (vectorLayer.features[f].id == re_device_id) {
            //console.log(data);
            //console.log(Object.keys(data).length);
            //Close any open popup
            if ($.isEmptyObject(map.popups[0])){

            } else {
                controls['selector'].unselectAll();
            }
            var iconFeature = vectorLayer.features[f];

            iconFeature.style.rotation = direction;
            iconFeature.id = re_device_id;
            
            iconFeature.style.label = regno +'\n'+speed + ' km/h';
        

            iconFeature.move(myLatlngf);
            //map.setCenter(myLatlngf, 18);
            if(vectorLayer.features.length == 1){
                //map.setCenter(myLatlngf, map.zoom);
            }

            break;
        }
    }
}

//Update Markers Alreadyb Loaded on Map
function dashboardLocateAsset(re_device_id) {
    
    //var myLatlngf = new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857');
    
    for (var f = 0; f < vectorLayer.features.length; f++) {
        if (vectorLayer.features[f].id == re_device_id) {
            //console.log(data);
            
            //console.log(Object.keys(data).length);
            //Close any open popup
            if ($.isEmptyObject(map.popups[0])){

            } else {
                controls['selector'].unselectAll();
            }
            var iconFeature = vectorLayer.features[f];
            console.log(iconFeature);
            console.log(iconFeature.geometry);
            
            
            var lonlat = new OpenLayers.LonLat(iconFeature.geometry.x, iconFeature.geometry.y).transform(map.getProjectionObject(),new OpenLayers.Projection("EPSG:4326"));
            console.log(lonlat);
            
            lonlat.transform(new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
            map.setCenter(lonlat,18);
            
            break;
        }
    }
}

//Fetch New Fleet Data From Server
function initDashboardUpdate(orgid) {
    console.log("---------- init Dashboard Update RES ----------");
    console.log("---------- init Dashboard Update Org ---------- "+ orgid);
    var userid = window.localStorage.getItem("userid");
    //var orgid = window.localStorage.getItem("orgid");
    $.ajax({
        type: "POST",
        //url: baseurl+"/Fleet/appGetAssetBySerial",
        url: baseurl+"/Fleet/appRead",
        data: {
           list_limit: 0,
           userid: userid,
           orgid: orgid
        },
        beforeSend: function(){
        },
        success: function(data){
            if(data != ""){
                var alld = JSON.parse(data);
                //console.log(alld);
                if(alld.length > 0){
                    $.each(alld, function(index, item) {
                        //console.log(index + " -- AUTO -- UNIT: "+item.unitid + " LAT: "+item.latitude + " LON: "+item.longitude + " ATYPE: "+item.assettype + " DIRECTION: "+item.direction + " HEARTBEAT: "+item.heartbeat);
                        dashboardUpdateAsset(item.latitude,item.longitude,item.assettype,item.direction,item.unitid,item.speed,item.regno); 
                    });
                    
                    //var bounds = vectorLayer.getDataExtent();
			        //map.zoomToExtent(bounds);
			        //vectorLayer.setVisibility(1);
                }
            }
        }
    });
    
    timeoutId = setTimeout(() => {
        initDashboardUpdate(orgid);                        
    }, refreshTimeDashboard);
}

//Load All Fleet Markers
function initDashboard(mid,lat,lon,assettype,direction,device,orgid) {
    //console.log("---------- init Dashboard RES ----------");
    //console.log(" gMID: "+mid + " gLAT: "+lat + " gLON: "+lon + " gATYPE: "+assettype + " gDIRECTION: "+direction);
    console.log("---------- init Dashboard TIMEOUT ---------- " +timeoutId);
    if(timeoutId != 0){
        clearTimeout(timeoutId);
    }
    
    if(map == null || map == undefined){
    
        var ggl = new OpenLayers.Layer.Google('Google Road',{type: google.maps.MapTypeId.ROADMAP, numZoomLevels: 21, MAX_ZOOM_LEVEL: 22 });
        map = new OpenLayers.Map(mid, {
            layers: [ggl],
            center: new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857'),
            zoom: 10
        });
    }
    
    if(vectorLayer == null || vectorLayer == undefined){
        
        vectorLayer = new OpenLayers.Layer.Vector("Markers");
        map.addLayer(vectorLayer);
    }
    
    var assett = properIcon(assettype);
    if(assettype == '7') {
	    var hgt = 30;
	    var agl = 0;
	    var spc = 4;
	} else {
	    var hgt = 36;
	    var agl = direction;
	    var spc = 0;
	}
    
    var feature = new OpenLayers.Feature.Vector(
            new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
            {
                description: ''
            },
            {label: '', labelOutlineColor: '#fff',labelOutlineWidth: 4, labelAlign: 'cm', labelXOffset: 36, labelYOffset: 10,fontSize: "13px", fontWeight: "bold", fontFamily: 'roboto', externalGraphic: assett, graphicHeight: hgt, graphicXOffset: -12, graphicYOffset: -25, rotation: agl, strokeWidth: 4, strokeColor: '#fff' }
    );
    feature.id = device;
    vectorLayer.addFeatures(feature);
	vectorLayer.setVisibility(1);
	
	timeoutId = setTimeout(() => {
        initDashboardUpdate(orgid);                        
    }, startRefreshTime);
}
///////////////////////////////// DASHBOARD MAP END //////////////////////////////////

/////////////////////////////////// HISTORY MAP ///////////////////////////////////
/*
*Dashboard Load All Fleet & Auto Update Location Changes 
*/
function initHistoryMap(mid) {
    
    var ggl = new OpenLayers.Layer.Google('Google Road',{type: google.maps.MapTypeId.ROADMAP, numZoomLevels: 21, MAX_ZOOM_LEVEL: 22 });
    map = new OpenLayers.Map(mid, {
        layers: [ggl],
        center: new OpenLayers.LonLat(36.844459, parseFloat(-1.308410)).transform('EPSG:4326', 'EPSG:3857'),
        zoom: 15
    });
    
    //Init Map vectorLayer & lineLayer
    if (typeof vectorLayerStartEnd === 'undefined') {
		vectorLayerStartEnd = new OpenLayers.Layer.Vector("Start End Markers");
        map.addLayer(vectorLayerStartEnd);
        vectorLayerStartEnd.setVisibility(0);
	}
    //Init Map vectorLayerPlayBack
    if (typeof vectorLayerPlayBack === 'undefined') {
		vectorLayerPlayBack = new OpenLayers.Layer.Vector("PlayBack");
        map.addLayer(vectorLayerPlayBack);
        vectorLayerPlayBack.setVisibility(0);
	}
	
    if (typeof vectorLayer === 'undefined') {
		vectorLayer = new OpenLayers.Layer.Vector("Markers");
        map.addLayer(vectorLayer);
        vectorLayer.setVisibility(0);
	}
	
	if (typeof lineLayer === 'undefined') {
		lineLayer = new OpenLayers.Layer.Vector("Line Layer"); 
        map.addLayer(lineLayer);
        lineLayer.setVisibility(0);
	}
    /*vectorLayer = new OpenLayers.Layer.Vector("Markers");
    map.addLayer(vectorLayer);
    
    var assett = properIcon(assettype);
    if(assettype == '7') {
	    var hgt = 30;
	    var agl = 0;
	    var spc = 4;
	} else {
	    var hgt = 36;
	    var agl = direction;
	    var spc = 0;
	}
    
    var feature = new OpenLayers.Feature.Vector(
            new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
            {
                description: ''
            },
            {label: '', labelOutlineColor: '#fff',labelOutlineWidth: 4, labelAlign: 'cm', labelXOffset: 36, labelYOffset: 10,fontSize: "13px", fontWeight: "bold", fontFamily: 'roboto', externalGraphic: "", graphicHeight: hgt, graphicXOffset: -12, graphicYOffset: -25, rotation: agl, strokeWidth: 4, strokeColor: '#fff' }
    );
    feature.id = device;
    
    vectorLayer.addFeatures(feature);
	vectorLayer.setVisibility(1);*/
	
}

function initHistoryMapNew(mid,lat,lon) {
    
    if (typeof map === 'undefined') {
        var ggl = new OpenLayers.Layer.Google('Google Road',{type: google.maps.MapTypeId.ROADMAP, numZoomLevels: 21, MAX_ZOOM_LEVEL: 22 });
        map = new OpenLayers.Map(mid, {
            layers: [ggl],
            center: new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857'),
            zoom: 15
        });
    }
    
    //Init Map vectorLayer & lineLayer
    if (typeof vectorLayerStartEnd === 'undefined') {
		vectorLayerStartEnd = new OpenLayers.Layer.Vector("Start End Markers");
        map.addLayer(vectorLayerStartEnd);
        vectorLayerStartEnd.setVisibility(0);
	}
	
	//Init Map vectorLayerPlayBack
    if (typeof vectorLayerPlayBack === 'undefined') {
		vectorLayerPlayBack = new OpenLayers.Layer.Vector("PlayBack");
        map.addLayer(vectorLayerPlayBack);
        vectorLayerPlayBack.setVisibility(0);
	}
	
    if (typeof vectorLayer === 'undefined') {
		vectorLayer = new OpenLayers.Layer.Vector("Markers");
        map.addLayer(vectorLayer);
        vectorLayer.setVisibility(0);
	}
	
	if (typeof lineLayer === 'undefined') {
		lineLayer = new OpenLayers.Layer.Vector("Line Layer"); 
        map.addLayer(lineLayer);
        lineLayer.setVisibility(0);
	}
    /*vectorLayer = new OpenLayers.Layer.Vector("Markers");
    map.addLayer(vectorLayer);
    
    var assett = properIcon(assettype);
    if(assettype == '7') {
	    var hgt = 30;
	    var agl = 0;
	    var spc = 4;
	} else {
	    var hgt = 36;
	    var agl = direction;
	    var spc = 0;
	}
    
    var feature = new OpenLayers.Feature.Vector(
            new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
            {
                description: ''
            },
            {label: '', labelOutlineColor: '#fff',labelOutlineWidth: 4, labelAlign: 'cm', labelXOffset: 36, labelYOffset: 10,fontSize: "13px", fontWeight: "bold", fontFamily: 'roboto', externalGraphic: "", graphicHeight: hgt, graphicXOffset: -12, graphicYOffset: -25, rotation: agl, strokeWidth: 4, strokeColor: '#fff' }
    );
    feature.id = device;
    
    vectorLayer.addFeatures(feature);
	vectorLayer.setVisibility(1);*/
	
}

function initHistory(mid,lat,lon,assettype,direction,device) {
    
    var ggl = new OpenLayers.Layer.Google('Google Road',{type: google.maps.MapTypeId.ROADMAP, numZoomLevels: 21, MAX_ZOOM_LEVEL: 22 });
    map = new OpenLayers.Map(mid, {
        layers: [ggl],
        center: new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857'),
        zoom: 10
    });
    vectorLayer = new OpenLayers.Layer.Vector("Markers");
    lineLayer = new OpenLayers.Layer.Vector("Line Layer"); 
    map.addLayer(vectorLayer);
    map.addLayer(lineLayer);
    
    var assett = properIcon(assettype);
    if(assettype == '7') {
	    var hgt = 30;
	    var agl = 0;
	    var spc = 4;
	} else {
	    var hgt = 36;
	    var agl = direction;
	    var spc = 0;
	}
    
    var feature = new OpenLayers.Feature.Vector(
            new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
            {
                description: ''
            },
            {label: '', labelOutlineColor: '#fff',labelOutlineWidth: 4, labelAlign: 'cm', labelXOffset: 36, labelYOffset: 10,fontSize: "13px", fontWeight: "bold", fontFamily: 'roboto', externalGraphic: "", graphicHeight: hgt, graphicXOffset: -12, graphicYOffset: -25, rotation: agl, strokeWidth: 4, strokeColor: '#fff' }
    );
    feature.id = device;
    
    vectorLayer.addFeatures(feature);
	vectorLayer.setVisibility(1);
	
}

///////////////////////////////// HISTORY MAP END /////////////////////////////////

/////////////////////////////////// DASHBOARD LIST ///////////////////////////////////
/*
*Dashboard Load All Fleet & Auto Update Location Changes 
*/
function init(mid,lat,lon,assettype,direction,regno,speed) {
    
    console.log("gMID: "+mid);
    console.log("gLAT: "+lat);
    console.log("gLON: "+lon);
    console.log("gATYPE: "+assettype);
    console.log("gDIRECTION: "+direction);
    
    var ggl = new OpenLayers.Layer.Google('Google Road',{type: google.maps.MapTypeId.ROADMAP, numZoomLevels: 21, MAX_ZOOM_LEVEL: 22 });
    map = new OpenLayers.Map(mid, {
        layers: [ggl],
        controls: [],
        center: new OpenLayers.LonLat(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:3857'),
        zoom: 10
    });
    vectorLayer = new OpenLayers.Layer.Vector("Markers");
    map.addLayer(vectorLayer);
    
    var assett = properIcon(assettype);
    if(assettype == '7') {
	    var hgt = 30;
	    var agl = 0;
	    var spc = 4;
	} else {
	    var hgt = 36;
	    var agl = direction;
	    var spc = 0;
	}
    
    var feature = new OpenLayers.Feature.Vector(
            new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
            {
                description: ''
            },
            {label: speed + ' km/h', labelOutlineColor: '#fff',labelOutlineWidth: 4, labelAlign: 'cm', labelXOffset: 36, labelYOffset: 10,fontSize: "13px", fontWeight: "bold", fontFamily: 'roboto', externalGraphic: assett, graphicHeight: hgt, graphicXOffset: -12, graphicYOffset: -25, rotation: agl, strokeWidth: 4, strokeColor: '#fff' }
    );
    vectorLayer.addFeatures(feature);
	vectorLayer.setVisibility(1);
}

///////////////////////////////// DASHBOARD LIST END /////////////////////////////////

function properIcon(t){
	var asset = "";
	if(t == '1'){
		//car
		asset = "assets/img/car/car/car.png";
	}else if(t == '2'){
		//van
		asset = "assets/img/car/van/van.png";
	}else if(t == '3'){
		//truck
		asset = "assets/img/car/lorry/lorry.png";
	}else if(t == '4'){
		//bus
		asset = "assets/img/car/van/van.png";
	}else if(t == '5'){
		//motorcycle
		asset = "assets/img/car/bike/bike.png";
	}else if(t == '6'){
		//trailer
		asset = "assets/img/car/trailer/trailer.png";
	}else if(t == '7'){
		//blicking arrow
		asset = "assets/img/gif/people.png";
	}else if(t == '8'){
		//fuel sensor
		asset = "assets/img/fuel3.png";
	}
	return asset;
}

function properIconHistory(t,id){
	var asset = "";
	if(fl[0] == id){
		//asset = "assets/img/map/startpoint.png";
		asset = "assets/img/map/start_flag_green_icon.png";
	} else if(fl[1] == id){
		//asset = "assets/img/map/endpoint.png";
		asset = "assets/img/map/end_flag_red_icon.png";
	} else {
		//asset = "assets/img/map/d.png";
		asset = "assets/img/map/point_abo.png";
	}
	return asset;
}

function properIconHistoryNew(t,id){
	var asset = "";
	
	if(t == '0'){
		//Start Point
		asset = "assets/img/map/startpoint.png";
	} else if(t == '1'){
		//End Point
		asset = "assets/img/map/endpoint.png";
	} else {
		asset = "assets/img/map/d.png";
	}
	return asset;
}

//############################### Markers init #############
function initEachMarker(pos, id, angle, door, acc, lon, lat, speed, device, time, loc, bat, type, arrcount = 1){	
	var assett = properIconHistory(pos, id);
	
	// Define markers as "features" of the vector layer: EPSG:900913
	if(fl[0] == id){
		var gh = 36;
		var gw = 36;
		var feature = new OpenLayers.Feature.Vector(
			new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
			{
				description: ''
			},
			{externalGraphic: assett, graphicHeight: gh, graphicWidth:gw, graphicXOffset: -12, graphicYOffset: -25, rotation: angle}
	    );
	
    	if (type) {
    		feature.id = id;
    		feature['unit'] = device;
    		feature['speed'] = speed;
    		feature['time'] = time;
    		feature['acc'] = acc;
    		feature['door'] = door;
    		feature['battery'] = bat;
    	}//title='Door Status'|title='Engine On or Off Status'
    	if (feature.battery >= 60) {
    		var b = "<span style='color:green;'>"+feature.battery+" %</span>";
    	} else if (feature.battery >= 30) {
    		var b = "<span style='color:orange;'>"+feature.battery+" %</span>";
    	}else{
    		var b = "<span style='color:red;'>"+feature.battery+" %</span>";
    	}
    	if (feature.door == 0) {
    		var d = "<span style='color:green;'>close</span>";
    	} else if (feature.door == 1) {
    		var d = "<span style='color:red;'>open</span>";
    	}
    	if (feature.acc == 1) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:green;'></i>";
    	} else if (feature.acc == 0) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:red;'></i>";
    	}
    	var descContent = '<h2>'+feature.speed+' Km/h</h2>'
    	+'<table>'
    	+'<tr>'
    	+'<td class="boldtd" >Unit :</td>'
    	+'<td class="spacetd" >'+feature.unit+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Speed :</td>'
    	+'<td class="spacetd">'+feature.speed+' Km/h</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Engine :</td>'
    	+'<td class="spacetd">'+onoffh+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Battery :</td>'
    	+'<td class="spacetd" >'+b+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Door :</td>'
    	+'<td class="spacetd" >'+d+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Time :</td>'
    	+'<td class="spacetd" >'+time+'</td>'
    	+'</tr>'
    	+'</table>'
    	+'<p>'+loc+'</p>';
    
    	feature.attributes.description = descContent;
    	feature.data.description = descContent;
    	
    	vectorLayerStartEnd.addFeatures(feature);
    	//console.log(" --------- Start Point --------- " + assett);
	} else if(fl[1] == id){
		var gh = 36;
		var gw = 36;
		var feature = new OpenLayers.Feature.Vector(
			new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
			{
				description: ''
			},
			{externalGraphic: assett, graphicHeight: gh, graphicWidth:gw, graphicXOffset: -12, graphicYOffset: -25, rotation: angle}
	    );
    	if (type) {
    		feature.id = id;
    		feature['unit'] = device;
    		feature['speed'] = speed;
    		feature['time'] = time;
    		feature['acc'] = acc;
    		feature['door'] = door;
    		feature['battery'] = bat;
    	}//title='Door Status'|title='Engine On or Off Status'
    	if (feature.battery >= 60) {
    		var b = "<span style='color:green;'>"+feature.battery+" %</span>";
    	} else if (feature.battery >= 30) {
    		var b = "<span style='color:orange;'>"+feature.battery+" %</span>";
    	}else{
    		var b = "<span style='color:red;'>"+feature.battery+" %</span>";
    	}
    	if (feature.door == 0) {
    		var d = "<span style='color:green;'>close</span>";
    	} else if (feature.door == 1) {
    		var d = "<span style='color:red;'>open</span>";
    	}
    	if (feature.acc == 1) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:green;'></i>";
    	} else if (feature.acc == 0) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:red;'></i>";
    	}
    	var descContent = '<h2>'+feature.speed+' Km/h</h2>'
    	+'<table>'
    	+'<tr>'
    	+'<td class="boldtd" >Unit :</td>'
    	+'<td class="spacetd" >'+feature.unit+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Speed :</td>'
    	+'<td class="spacetd">'+feature.speed+' Km/h</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Engine :</td>'
    	+'<td class="spacetd">'+onoffh+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Battery :</td>'
    	+'<td class="spacetd" >'+b+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Door :</td>'
    	+'<td class="spacetd" >'+d+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Time :</td>'
    	+'<td class="spacetd" >'+time+'</td>'
    	+'</tr>'
    	+'</table>'
    	+'<p>'+loc+'</p>';
    
    	feature.attributes.description = descContent;
    	feature.data.description = descContent;
    	
    	vectorLayerStartEnd.addFeatures(feature);
    	//console.log(" --------- End Point --------- " + assett);
	} else {
		var gh = 20;
		var gw = 18;
		
		var feature = new OpenLayers.Feature.Vector(
			new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
			{
				description: ''
			},
			{externalGraphic: assett, graphicHeight: gh, graphicWidth:gw, graphicXOffset: -12, graphicYOffset: -25, rotation: angle}
	    );
    	if (type) {
    		feature.id = id;
    		feature['unit'] = device;
    		feature['speed'] = speed;
    		feature['time'] = time;
    		feature['acc'] = acc;
    		feature['door'] = door;
    		feature['battery'] = bat;
    	}//title='Door Status'|title='Engine On or Off Status'
    	if (feature.battery >= 60) {
    		var b = "<span style='color:green;'>"+feature.battery+" %</span>";
    	} else if (feature.battery >= 30) {
    		var b = "<span style='color:orange;'>"+feature.battery+" %</span>";
    	}else{
    		var b = "<span style='color:red;'>"+feature.battery+" %</span>";
    	}
    	if (feature.door == 0) {
    		var d = "<span style='color:green;'>close</span>";
    	} else if (feature.door == 1) {
    		var d = "<span style='color:red;'>open</span>";
    	}
    	if (feature.acc == 1) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:green;'></i>";
    	} else if (feature.acc == 0) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:red;'></i>";
    	}
    	var descContent = '<h2>'+feature.speed+' Km/h</h2>'
    	+'<table>'
    	+'<tr>'
    	+'<td class="boldtd" >Unit :</td>'
    	+'<td class="spacetd" >'+feature.unit+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Speed :</td>'
    	+'<td class="spacetd">'+feature.speed+' Km/h</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Engine :</td>'
    	+'<td class="spacetd">'+onoffh+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Battery :</td>'
    	+'<td class="spacetd" >'+b+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Door :</td>'
    	+'<td class="spacetd" >'+d+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Time :</td>'
    	+'<td class="spacetd" >'+time+'</td>'
    	+'</tr>'
    	+'</table>'
    	+'<p>'+loc+'</p>';
    
    	feature.attributes.description = descContent;
    	feature.data.description = descContent;
    	
    	vectorLayer.addFeatures(feature);
    	//console.log(" --------- Middle Point --------- " + assett);
	}
	
	if(arrcount > 1) {
	    //console.log(arrcount + " --------- 2 DATA MARKER --------- "); 
	    var gh = 20;
		var gw = 18;
		
		var feature = new OpenLayers.Feature.Vector(
			new OpenLayers.Geometry.Point(parseFloat(lon), parseFloat(lat)).transform('EPSG:4326', 'EPSG:900913'),
			{
				description: ''
			},
			{externalGraphic: assett, graphicHeight: gh, graphicWidth:gw, graphicXOffset: -12, graphicYOffset: -25, rotation: angle}
	    );
    	if (type) {
    		feature.id = id;
    		feature['unit'] = device;
    		feature['speed'] = speed;
    		feature['time'] = time;
    		feature['acc'] = acc;
    		feature['door'] = door;
    		feature['battery'] = bat;
    	}//title='Door Status'|title='Engine On or Off Status'
    	if (feature.battery >= 60) {
    		var b = "<span style='color:green;'>"+feature.battery+" %</span>";
    	} else if (feature.battery >= 30) {
    		var b = "<span style='color:orange;'>"+feature.battery+" %</span>";
    	}else{
    		var b = "<span style='color:red;'>"+feature.battery+" %</span>";
    	}
    	if (feature.door == 0) {
    		var d = "<span style='color:green;'>close</span>";
    	} else if (feature.door == 1) {
    		var d = "<span style='color:red;'>open</span>";
    	}
    	if (feature.acc == 1) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:green;'></i>";
    	} else if (feature.acc == 0) {
    		var onoffh = "<i title='Engine On or Off Status' class='fa fa-power-off fa-lg' style='color:red;'></i>";
    	}
    	var descContent = '<h2>'+feature.speed+' Km/h</h2>'
    	+'<table>'
    	+'<tr>'
    	+'<td class="boldtd" >Unit :</td>'
    	+'<td class="spacetd" >'+feature.unit+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Speed :</td>'
    	+'<td class="spacetd">'+feature.speed+' Km/h</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Engine :</td>'
    	+'<td class="spacetd">'+onoffh+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Battery :</td>'
    	+'<td class="spacetd" >'+b+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Door :</td>'
    	+'<td class="spacetd" >'+d+'</td>'
    	+'</tr>'
    	+'<tr>'
    	+'<td class="boldtd" >Time :</td>'
    	+'<td class="spacetd" >'+time+'</td>'
    	+'</tr>'
    	+'</table>'
    	+'<p>'+loc+'</p>';
    
    	feature.attributes.description = descContent;
    	feature.data.description = descContent;
    	
    	vectorLayer.addFeatures(feature);
    	//console.log(" --------- Middle Point --------- " + assett);
	}
	
		
}

function phpLikeDate(format, timestamp) {
    //  discuss at: http://phpjs.org/functions/date/
    // original by: Carlos R. L. Rodrigues (http://www.jsfromhell.com)
    // original by: gettimeofday
    //    parts by: Peter-Paul Koch (http://www.quirksmode.org/js/beat.html)
    // improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // improved by: MeEtc (http://yass.meetcweb.com)
    // improved by: Brad Touesnard
    // improved by: Tim Wiel
    // improved by: Bryan Elliott
    // improved by: David Randall
    // improved by: Theriault
    // improved by: Theriault
    // improved by: Brett Zamir (http://brett-zamir.me)
    // improved by: Theriault
    // improved by: Thomas Beaucourt (http://www.webapp.fr)
    // improved by: JT
    // improved by: Theriault
    // improved by: Rafał Kukawski (http://blog.kukawski.pl)
    // improved by: Theriault
    //    input by: Brett Zamir (http://brett-zamir.me)
    //    input by: majak
    //    input by: Alex
    //    input by: Martin
    //    input by: Alex Wilson
    //    input by: Haravikk
    // bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // bugfixed by: majak
    // bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // bugfixed by: Brett Zamir (http://brett-zamir.me)
    // bugfixed by: omid (http://phpjs.org/functions/380:380#comment_137122)
    // bugfixed by: Chris (http://www.devotis.nl/)
    //        note: Uses global: php_js to store the default timezone
    //        note: Although the function potentially allows timezone info (see notes), it currently does not set
    //        note: per a timezone specified by date_default_timezone_set(). Implementers might use
    //        note: this.php_js.currentTimezoneOffset and this.php_js.currentTimezoneDST set by that function
    //        note: in order to adjust the dates in this function (or our other date functions!) accordingly
    //   example 1: date('H:m:s \\m \\i\\s \\m\\o\\n\\t\\h', 1062402400);
    //   returns 1: '09:09:40 m is month'
    //   example 2: date('F j, Y, g:i a', 1062462400);
    //   returns 2: 'September 2, 2003, 2:26 am'
    //   example 3: date('Y W o', 1062462400);
    //   returns 3: '2003 36 2003'
    //   example 4: x = date('Y m d', (new Date()).getTime()/1000);
    //   example 4: (x+'').length == 10 // 2009 01 09
    //   returns 4: true
    //   example 5: date('W', 1104534000);
    //   returns 5: '53'
    //   example 6: date('B t', 1104534000);
    //   returns 6: '999 31'
    //   example 7: date('W U', 1293750000.82); // 2010-12-31
    //   returns 7: '52 1293750000'
    //   example 8: date('W', 1293836400); // 2011-01-01
    //   returns 8: '52'
    //   example 9: date('W Y-m-d', 1293974054); // 2011-01-02
    //   returns 9: '52 2011-01-02'

    var that = this;
    var jsdate, f;
    // Keep this here (works, but for code commented-out below for file size reasons)
    // var tal= [];
    var txt_words = [
        'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat',
        'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
        'Jul', 'Augt', 'Sep', 'Oct', 'Nov', 'Dec'
    ];
    // trailing backslash -> (dropped)
    // a backslash followed by any character (including backslash) -> the character
    // empty string -> empty string
    var formatChr = /\\?(.?)/gi;
    var formatChrCb = function (t, s) {
        return f[t] ? f[t]() : s;
    };
    var _pad = function (n, c) {
        n = String(n);
        while (n.length < c) {
            n = '0' + n;
        }
        return n;
    };
    f = {
        // Day
        d: function () { // Day of month w/leading 0; 01..31
            return _pad(f.j(), 2);
        },
        D: function () { // Shorthand day name; Mon...Sun
            return f.l()
                    .slice(0, 3);
        },
        j: function () { // Day of month; 1..31
            return jsdate.getDate();
        },
        l: function () { // Full day name; Monday...Sunday
            return txt_words[f.w()] + 'day';
        },
        N: function () { // ISO-8601 day of week; 1[Mon]..7[Sun]
            return f.w() || 7;
        },
        S: function () { // Ordinal suffix for day of month; st, nd, rd, th
            var j = f.j();
            var i = j % 10;
            if (i <= 3 && parseInt((j % 100) / 10, 10) == 1) {
                i = 0;
            }
            return ['st', 'nd', 'rd'][i - 1] || 'th';
        },
        w: function () { // Day of week; 0[Sun]..6[Sat]
            return jsdate.getDay();
        },
        z: function () { // Day of year; 0..365
            var a = new Date(f.Y(), f.n() - 1, f.j());
            var b = new Date(f.Y(), 0, 1);
            return Math.round((a - b) / 864e5);
        },

        // Week
        W: function () { // ISO-8601 week number
            var a = new Date(f.Y(), f.n() - 1, f.j() - f.N() + 3);
            var b = new Date(a.getFullYear(), 0, 4);
            return _pad(1 + Math.round((a - b) / 864e5 / 7), 2);
        },

        // Month
        F: function () { // Full month name; January...December
            return txt_words[6 + f.n()];
        },
        m: function () { // Month w/leading 0; 01...12
            return _pad(f.n(), 2);
        },
        M: function () { // Shorthand month name; Jan...Dec
            return f.F()
                    .slice(0, 3);
        },
        n: function () { // Month; 1...12
            return jsdate.getMonth() + 1;
        },
        t: function () { // Days in month; 28...31
            return (new Date(f.Y(), f.n(), 0))
                    .getDate();
        },

        // Year
        L: function () { // Is leap year?; 0 or 1
            var j = f.Y();
            return j % 4 === 0 & j % 100 !== 0 | j % 400 === 0;
        },
        o: function () { // ISO-8601 year
            var n = f.n();
            var W = f.W();
            var Y = f.Y();
            return Y + (n === 12 && W < 9 ? 1 : n === 1 && W > 9 ? -1 : 0);
        },
        Y: function () { // Full year; e.g. 1980...2010
            return jsdate.getFullYear();
        },
        y: function () { // Last two digits of year; 00...99
            return f.Y()
                    .toString()
                    .slice(-2);
        },

        // Time
        a: function () { // am or pm
            return jsdate.getHours() > 11 ? 'pm' : 'am';
        },
        A: function () { // AM or PM
            return f.a()
                    .toUpperCase();
        },
        B: function () { // Swatch Internet time; 000..999
            var H = jsdate.getUTCHours() * 36e2;
            // Hours
            var i = jsdate.getUTCMinutes() * 60;
            // Minutes
            var s = jsdate.getUTCSeconds(); // Seconds
            return _pad(Math.floor((H + i + s + 36e2) / 86.4) % 1e3, 3);
        },
        g: function () { // 12-Hours; 1..12
            return f.G() % 12 || 12;
        },
        G: function () { // 24-Hours; 0..23
            return jsdate.getHours();
        },
        h: function () { // 12-Hours w/leading 0; 01..12
            return _pad(f.g(), 2);
        },
        H: function () { // 24-Hours w/leading 0; 00..23
            return _pad(f.G(), 2);
        },
        i: function () { // Minutes w/leading 0; 00..59
            return _pad(jsdate.getMinutes(), 2);
        },
        s: function () { // Seconds w/leading 0; 00..59
            return _pad(jsdate.getSeconds(), 2);
        },
        u: function () { // Microseconds; 000000-999000
            return _pad(jsdate.getMilliseconds() * 1000, 6);
        },

        // Timezone
        e: function () { // Timezone identifier; e.g. Atlantic/Azores, ...
            // The following works, but requires inclusion of the very large
            // timezone_abbreviations_list() function.
            /*              return that.date_default_timezone_get();
             */
            throw 'Not supported (see source code of date() for timezone on how to add support)';
        },
        I: function () { // DST observed?; 0 or 1
            // Compares Jan 1 minus Jan 1 UTC to Jul 1 minus Jul 1 UTC.
            // If they are not equal, then DST is observed.
            var a = new Date(f.Y(), 0);
            // Jan 1
            var c = Date.UTC(f.Y(), 0);
            // Jan 1 UTC
            var b = new Date(f.Y(), 6);
            // Jul 1
            var d = Date.UTC(f.Y(), 6); // Jul 1 UTC
            return ((a - c) !== (b - d)) ? 1 : 0;
        },
        O: function () { // Difference to GMT in hour format; e.g. +0200
            var tzo = jsdate.getTimezoneOffset();
            var a = Math.abs(tzo);
            return (tzo > 0 ? '-' : '+') + _pad(Math.floor(a / 60) * 100 + a % 60, 4);
        },
        P: function () { // Difference to GMT w/colon; e.g. +02:00
            var O = f.O();
            return (O.substr(0, 3) + ':' + O.substr(3, 2));
        },
        T: function () { // Timezone abbreviation; e.g. EST, MDT, ...
            // The following works, but requires inclusion of the very
            // large timezone_abbreviations_list() function.
            /*              var abbr, i, os, _default;
             if (!tal.length) {
             tal = that.timezone_abbreviations_list();
             }
             if (that.php_js && that.php_js.default_timezone) {
             _default = that.php_js.default_timezone;
             for (abbr in tal) {
             for (i = 0; i < tal[abbr].length; i++) {
             if (tal[abbr][i].timezone_id === _default) {
             return abbr.toUpperCase();
             }
             }
             }
             }
             for (abbr in tal) {
             for (i = 0; i < tal[abbr].length; i++) {
             os = -jsdate.getTimezoneOffset() * 60;
             if (tal[abbr][i].offset === os) {
             return abbr.toUpperCase();
             }
             }
             }
             */
            return 'UTC';
        },
        Z: function () { // Timezone offset in seconds (-43200...50400)
            return -jsdate.getTimezoneOffset() * 60;
        },

        // Full Date/Time
        c: function () { // ISO-8601 date.
            return 'Y-m-d\\TH:i:sP'.replace(formatChr, formatChrCb);
        },
        r: function () { // RFC 2822
            return 'D, d M Y H:i:s O'.replace(formatChr, formatChrCb);
        },
        U: function () { // Seconds since UNIX epoch
            return jsdate / 1000 | 0;
        }
    };
    this.date = function (format, timestamp) {
        that = this;
        jsdate = (timestamp === undefined ? new Date() : // Not provided
                (timestamp instanceof Date) ? new Date(timestamp) : // JS Date()
                new Date(timestamp * 1000) // UNIX timestamp (auto-convert to int)
                );
        return format.replace(formatChr, formatChrCb);
    };
    return this.date(format, timestamp);
}

function toTimestamp(strDate) {
    var datum = Date.parse(strDate);
    return datum / 1000;
}